import React, { useEffect, useState } from "react";
import {
  Col,
  Container,
  Dropdown,
  DropdownItem,
  DropdownMenu,
  DropdownToggle,
  Input,
  InputGroup,
  Row,
} from "reactstrap";
import { Logo, Logo2 } from "@/components/elements/Logo";
import useOutsideDropdown from "@/utils/useOutsideDropdown";
import RightNav from "./RightNav";
import SearchSuggestionBox from "@/components/elements/SearchSuggestionBox";
// import Cart from './rightNavComponents/Cart';
import { IoCallSharp } from "react-icons/io5";
import { FaUser, FaWhatsapp } from "react-icons/fa";
import { User, LogOut, Link } from "react-feather";
import LogoutButton from "@/components/common/LogoutButton";


const TopBarTwo = ({ logo }) => {
  const [dropDown, setDropDown] = useState(false);
  const [dropDownValue, setDropDownValue] = useState("Apartment");
  const [searchInput, setSearchInput] = useState("");
  const [searchDropDown, setSearchDropDown] = useState(false);
  const { ref, isComponentVisible, setIsComponentVisible } =
    useOutsideDropdown(false);

  const [isDropdownOpen, setDropdownOpen] = useState(false); // State to control dropdown visibility
  const [isLoggedIn, setIsLoggedIn] = useState(false); // State to track if user is logged in

  // Function to toggle dropdown on user icon click
  const toggleDropdown = () => {
    setDropdownOpen(!isDropdownOpen);
  };

  const token = localStorage.getItem("token");
  // Check if user is logged in based on token in local storage
  useEffect(() => {

    if (token) {
      setIsLoggedIn(true);
    }
  }, []);


  const handleLogout = async () => {
    try {


      // Make API call to logout
      if (token) {
        const response = await fetch(`${process.env.NEXT_PUBLIC_BASE_URL}/logout`, {
          method: "POST",
          headers: {
            "Content-Type": "application/json",
            Authorization: `Bearer ${token}`,
          },
        });
        if (response.data.message === "Unauthenticated.") {
          localStorage.clear();
          window.location.href = '/';
        }
        if (response.ok) {
          // On successful logout, clear the token and update the state
          localStorage.removeItem("token");
          setIsLoggedIn(false);
          // Optionally, you can redirect the user to the homepage or login page
          window.location.href = "/"; // Redirecting to home page
        } else {
          console.error("Logout failed");
        }
      }
    } catch (error) {
      console.error("Logout error: ", error);
      if (error.response && error.response.data && error.response.data.message === 'Unauthenticated.') {
        localStorage.clear();
        window.location.href = '/';
      }
    }
  };

  return (
    <div className="top-bar two light-bg-two">
      <Container>
        <Row>
          <Col>
            <div className="justify-content-end top-content top-nav two">
              <ul class="user-login-wrapper">
                {/* <li className="!flex">
                  <span><IoCallSharp /></span>
                  <a href="tel:90632 91050" class="tel p-l-15">
                    90632 91050
                  </a>
                </li> */}
                <li className="!flex">
                  <span>
                    {/* <IoCallSharp /> */}
                    <FaWhatsapp size={20} />
                  </span>
                  <a href="tel:98490 43980" class="tel p-l-15">
                    98490 43980
                  </a>
                </li>
                <li className="!flex" onClick={toggleDropdown}>
                  <span >

                    {isLoggedIn ? (
                      // Show logout icon if user is logged in
                      <User />
                    ) : (
                      // Show login icon if user is not logged in
                      <User />
                    )}
                    <ul className={`user-dropdown-menu ${isDropdownOpen ? "open" : ""}`}>
                      {isLoggedIn ? (
                        <>
                          <li>
                            <a class="btn btn-gradient" href="/pages/user-panel/user-dashboard">
                              Dashboard
                            </a>
                          </li>

                          <LogoutButton />
                        </>
                      ) : (
                        <>
                          <li>
                            <a class="btn btn-gradient" href="/pages/other-pages/customer-login">
                              Customer Login
                            </a>
                          </li>
                        </>
                      )}
                    </ul>

                  </span>
                  <a
                    href="#"
                    data-toggle="modal"
                    data-target="#signinModal"
                    class="signin p-l-15"
                  >
                    Sign In
                  </a>{" "}
                </li>
                <li>
                  {/* <a
                    href="#"
                    data-toggle="modal"
                    data-target="#registerModal"
                    class="label label-gradient color-6 " 
                  >
                    Empanel Now
                  </a> */}
                </li>
              </ul>
            </div>
          </Col>
        </Row>
      </Container>
    </div>
  );
};

export default TopBarTwo;
