"use client";
import React, { useEffect, Fragment, useState } from "react";
import { User } from "react-feather";
import { Col, Container, Row, Alert, Spinner } from "reactstrap";
import { useRouter } from 'next/navigation';
import { useDispatch, useSelector } from 'react-redux';
import { setMobileNumber, setOtp, setIsOtpSent, setMessage } from '../../../../../redux-toolkit/reducers/loginSlice'; // Updated path
import Breadcrumb from "@/layout/Breadcrumb/Breadcrumb";
import NavbarThree from "@/layout/headers/NavbarThree";
import FooterThree from "@/layout/footers/FooterThree";

const Login = () => {
  const router = useRouter();
  const BASE_URL = process.env.NEXT_PUBLIC_BASE_URL;

  const dispatch = useDispatch();
  const { mobileNumber, otp, isOtpSent, message } = useSelector(state => state.login);
  const[Loader, setLoader] = useState(false)


  useEffect(() => {
    // Redirect to the homepage if token exists in localStorage
    const token = localStorage.getItem("token");
    if (token) {
      router.push("/");
    }
  }, [router]);
  const handleSendOtp = async (e) => {
    e.preventDefault();
    dispatch(setMessage({ text: '', type: '' }));
   setLoader(true)
    try {
      const response = await fetch(`${BASE_URL}/send-otp`, {
        method: 'POST',
        headers: { 'Content-Type': 'application/json' },
        body: JSON.stringify({ mobile: mobileNumber }), 
      });

      if (response.ok) {
        const data = await response.json();
        if (data.code != '0') {
          dispatch(setIsOtpSent(true));
        }
        dispatch(setMessage({ text: data.message, type: 'success' }));
      } else {
        const errorData = await response.json();
        dispatch(setMessage({ text: errorData.message, type: 'error' }));
      }
    } catch (error) {
      console.error("Error sending OTP:", error);
      dispatch(setMessage({ text: "Failed to send OTP, please try again.", type: 'error' }));
    }
    finally{
      setLoader(false)
    }
  };

  const handleVerifyOtp = async (e) => {
    e.preventDefault();
    dispatch(setMessage({ text: '', type: '' }));

    try {
      const response = await fetch(`${BASE_URL}/verify-otp`, {
        method: 'POST',
        headers: { 'Content-Type': 'application/json' },
        body: JSON.stringify({ mobile: mobileNumber, otp }), // Removed role from request
      });

      if (response.ok) {
        const data = await response.json();
        localStorage.setItem('token', data.token);
        localStorage.setItem('user', JSON.stringify(data.data));

        dispatch(setMessage({ text: "Login successful!", type: 'success' }));
        router.push('/pages/user-panel/user-dashboard');
      } else {
        const errorData = await response.json();
        dispatch(setMessage({ text: errorData.message, type: 'error' }));
      }
    } catch (error) {
      console.error("Error verifying OTP:", error);
      dispatch(setMessage({ text: "OTP verification failed, please try again.", type: 'error' }));
    }
  };

  return (
    <Fragment>
      <NavbarThree />
      {/* <Breadcrumb /> */}
      <div className='login-wrap'>
        <Container>
          <Row className='log-in'>
            <Col xl='5' lg='7' md='9' sm='10'>

              <div className="assatz-logo">
                <img src="/assets/images/logo/assatz.webp" className="img-fluid m-0" alt="" />
              </div>
              <div className='theme-card'>
                <div className='title-3 text-start'>
                  <h2>Investor</h2>
                  <h2>Log in / Sign up</h2>
                </div>
                <form onSubmit={isOtpSent ? handleVerifyOtp : handleSendOtp}>
                  {message.text && (
                    <Alert color={message.type === 'success' ? 'success' : 'danger'}>
                      {message.text}
                    </Alert>
                  )}

                  {/* Mobile number input */}
                  <div className='form-group'>
                    <div className='input-group'>
                      <div className='input-group-prepend'>
                        <div className='input-group-text'>
                          <User />
                        </div>
                      </div>
                      <input
                        type='text'
                        className='form-control'
                        placeholder='Enter Email'
                        value={mobileNumber}
                        onChange={(e) => dispatch(setMobileNumber(e.target.value))}
                        required
                      />
                    </div>
                  </div>

                  {/* OTP input */}
                  {isOtpSent && (
                    <div className='form-group'>
                      <div className='input-group'>
                        <div className='input-group-prepend'>
                          <div className='input-group-text'>OTP</div>
                        </div>
                        <input
                          type='text'
                          className='form-control'
                          placeholder='Enter OTP'
                          value={otp}
                          onChange={(e) => dispatch(setOtp(e.target.value))}
                          required
                        />
                      </div>
                    </div>
                  )}

                  <div className="d-flex justify-content-center mb-0">
                    {/* <button type='submit' className='btn btn-gradient text-center btn-pill me-sm-3 me-2'> */}
                    <button type='submit' className='btn assatz-btn dark text-center btn-pill me-sm-3 me-2'>
                      {
                      isOtpSent ?
                          (
                            <>
                             {Loader ? <Spinner size="sm"  color="">Loading...</Spinner>: ""} Verify OTP
                            </>
                          ) :
                       
                          (
                            <>
                             {Loader ? <Spinner   size="sm" className="">Loading...</Spinner>: ""} Send Otp
                            </>
                          )
                       }
                    </button>
                  </div>
                </form>
              </div>
            </Col>
          </Row>
        </Container>
      </div>
      {/* <FooterThree /> */}
    </Fragment>
  );
};

export default Login;
