import React, { useState } from "react";
import { Col, Container, Row } from "reactstrap";
import { Logo } from "@/components/elements/Logo";
import { FooterData } from "../../data/footerData";
import FooterBlog from "./elements/FooterBlog";
import FooterContactUsDetails from "./elements/FooterContactUsDetails";
import FooterLink from "./elements/FooterLink";
import FooterMap from "./elements/FooterMap";
import SubFooter from "./elements/SubFooter";

// Importing CSS for styling the WhatsApp floating icon (if applicable)
import "./FloatingWhatsAppIcon.css";

const FooterTwo = ({ logo }) => {
  const [isActive, setIsActive] = useState();

  /* return (
    <footer className="footer-dark">
      <div className="footer footer-custom-col">
        <Container>
          <Row>
            <FooterContactUsDetails
              isActive={isActive}
              setIsActive={setIsActive}
              logo={
                <a>
                  <img src="/assets/images/logo/3.png" alt="" />
                </a>
              }
            />
            <FooterLink value={FooterData.about} isActive={isActive} setIsActive={setIsActive} />
            <FooterMap isActive={isActive} setIsActive={setIsActive} />
            <FooterLink value={FooterData.tag} isActive={isActive} setIsActive={setIsActive} />
            <FooterBlog isActive={isActive} setIsActive={setIsActive} img={["/assets/images/footer/4.jpg", "/assets/images/footer/5.jpg"]} />
          </Row>
        </Container>
      </div>
      <SubFooter values={"sub-footer-dark"} />
      
      
      <a
        href="https://wa.me/9063291050" // Replace with your WhatsApp number
        className="floating-whatsapp-icon"
        target="_blank"
        rel="noopener noreferrer"
      >
        <i className="fab fa-whatsapp"></i>
      </a>
    </footer>
  );
}; */
 return (
    <footer className="footer-brown">
      <div className="footer footer-custom-col">
        <Container>
          <Row className="row">
            <FooterContactUsDetails isActive={isActive} setIsActive={setIsActive} logo={logo || <Logo />} />
            <FooterLink value={FooterData.about} isActive={isActive} setIsActive={setIsActive} />
            <FooterMap isActive={isActive} setIsActive={setIsActive} />
            <FooterLink value={FooterData.tag} isActive={isActive} setIsActive={setIsActive} />
            <FooterBlog
              isActive={isActive}
              setIsActive={setIsActive}
              img={["/assets/images/footer/1.jpg", "/assets/images/footer/2.jpg"]}
            />
          </Row>
        </Container>
      </div>
      <SubFooter />

      {/* Floating WhatsApp Icon */}
      <a
        href="https://wa.me/9063291050" // Replace with your WhatsApp number
        className="floating-whatsapp-icon"
        target="_blank"
        rel="noopener noreferrer"
      >
        <i className="fab fa-whatsapp"></i>
      </a>
    </footer>
  );
};

export default FooterTwo;
