import Link from "next/link";
import React, { Fragment } from "react";
import { ChevronRight } from "react-feather";
import { Col } from "reactstrap";

const FooterLink = ({ value, isActive, setIsActive, liteFooter }) => {
  // Ensure that value.children exists and is an array
  if (!value || !Array.isArray(value.children)) {
    return null; // If no valid children, return null or handle it based on your requirements
  }

  return (
    <Col
      xl={value.title === "Useful Links" ? "3" : "2"}
      md="6"
      sm="12"
      className={`mb-4 ${value.title === "Tag" ? "order-lg" : ""}`}
    >
      <div className="footer-links footer-left-space">
        <h5
          className="footer-title"
          onClick={(e) => {
            e.preventDefault();
            setIsActive(value.title);
            // Close the menu if it's already active
            if (isActive === value.title) {
              setIsActive(null);
            }
          }}
        >
          {value.title}
          <span className="according-menu">
            <i className="fas fa-chevron-down"></i>
          </span>
        </h5>
        <ul className={`footer-content ${isActive === value.title ? "d-block" : "d-none d-md-block"}`}>
          {/* Iterate over the children array safely */}
          {value.children.map((child, i) => (
            <Fragment key={i}>
              {/* Check if `liteFooter` matches the current index to skip rendering */}
              {liteFooter !== i && (
                <li>
                  <Link href={child.link || "#"} passHref className="!hover:text-blue">
                    {liteFooter && <ChevronRight />}
                    {child.title}
                  </Link>
                </li>
              )}
            </Fragment>
          ))}
        </ul>
      </div>
    </Col>
  );
};

export default FooterLink;
