import Link from "next/link";
import React, { Fragment, useState, useEffect } from "react";
import { User, LogOut } from "react-feather"; // Import LogOut icon for logout
import { RightNavMenuItem } from "@/data/menu";
import Cart from "./rightNavComponents/Cart";
import Currency from "./rightNavComponents/Currency";
import Language from "./rightNavComponents/Language";
import LogoutButton from "../../../components/common/LogoutButton";
import "./Rightmodule.scss";  // Importing SCSS

// Main component
const RightNav = () => {
  const [isDropdownOpen, setDropdownOpen] = useState(false); // State to control dropdown visibility
  const [isLoggedIn, setIsLoggedIn] = useState(false); // State to track if user is logged in

  // Function to toggle dropdown on user icon click
  const toggleDropdown = () => {
    setDropdownOpen(!isDropdownOpen);
  };
		const token = localStorage.getItem("token");
  // Check if user is logged in based on token in local storage
  useEffect(() => {
    
    if (token) {
      setIsLoggedIn(true);
    }
  }, []);

  // Logout function
  const handleLogout = async () => {
    try {
      

      // Make API call to logout
      if (token) {
        const response = await fetch( `${process.env.NEXT_PUBLIC_BASE_URL}/logout`, {
          method: "POST",
          headers: {
            "Content-Type": "application/json",
            Authorization: `Bearer ${token}`,
          },
        });
		if (response.data.message === "Unauthenticated.") {
        localStorage.clear();
        window.location.href = '/';
      }
        if (response.ok) {
          // On successful logout, clear the token and update the state
          localStorage.removeItem("token");
          setIsLoggedIn(false);
          // Optionally, you can redirect the user to the homepage or login page
          window.location.href = "/"; // Redirecting to home page
        } else {
          console.error("Logout failed");
        }
      }
    } catch (error) {
      console.error("Logout error: ", error);
	  if (error.response && error.response.data && error.response.data.message === 'Unauthenticated.') {
        localStorage.clear();
        window.location.href = '/';
      }
    }
  };

  return (
    <ul className="header-right">
      <li className="right-menu">
        <ul className="nav-menu">
          {RightNavMenuItem.map((value, i) => (
            <Fragment key={i}>
              {/* User Dropdown */}
              {/* {value.title === "user" && (
                <li className="dropdown" onClick={toggleDropdown}>
                  <div className="user-dropdown">
                    {isLoggedIn ? (
                      // Show logout icon if user is logged in
                      <User />
                    ) : (
                      // Show login icon if user is not logged in
                      <User />
                    )}
                    <ul className={`user-dropdown-menu ${isDropdownOpen ? "open" : ""}`}>
                     {isLoggedIn ? (
					  <>
						<li>
						  <Link class="btn btn-gradient" href="/pages/user-panel/user-dashboard">
							Dashboard
						  </Link>
						</li>
						
						  <LogoutButton />
					  </>
					) : (
					  <>
						<li>
						  <Link class="btn btn-gradient" href="/pages/other-pages/franchise-login">
							Partner Login
						  </Link>
						</li>
					  </>
					)}
                    </ul>
                  </div>
                </li>
              )} */}
            </Fragment>
          ))}
        </ul>
      </li>
    </ul>
  );
};

export default RightNav;
