import React, { useEffect, useState } from "react";
import { Table, Alert } from "reactstrap";
import axios from "axios";
import Link from "next/link";
import "./projects.css";

const AccountBillingTab = () => {
  const BASE_URL = process.env.NEXT_PUBLIC_BASE_URL;
  const [getInvestments, setInvestments] = useState([]);
  const [successMessage, setSuccessMessage] = useState("");
  const [errorMessage, setErrorMessage] = useState("");

  useEffect(() => {
    const fetchInvestments = async () => {
      try {
        const token = localStorage.getItem("token");
        if (!token) {
          setErrorMessage("You need to be logged in to view investments.");
          return;
        }

        const response = await axios.post(
          `${BASE_URL}/investments`,
          {},
          {
            headers: { Authorization: `Bearer ${token}` },
          }
        );

        setInvestments(response.data.data);
      } catch (error) {
        console.error("Error fetching investments:", error);
        setErrorMessage(
          "Error fetching investments: " +
            (error.response?.data?.message || "Unknown error occurred.")
        );
      }
    };

    fetchInvestments();
  }, []);

  return (
    <div className="dashboard-content">
      <div className="projects-title">
        <h2>Account & Billing</h2>
      </div>

      {successMessage && <Alert color="success">{successMessage}</Alert>}
      {errorMessage && <Alert color="danger">{errorMessage}</Alert>}

      <Table striped bordered responsive>
        <thead>
          <tr>
            <th>#</th>
            <th>Project Name</th>
            <th>Amount Invested</th>
            <th>Share Price</th>
            <th>Transaction Date</th>
          </tr>
        </thead>
        <tbody>
          {getInvestments.length > 0 ? (
            getInvestments.map((investment, index) => (
              <tr key={investment.id}>
                <td>{index + 1}</td>
                <td>{investment.project.name}</td>
                <td>${investment.amount_invested}</td>
                <td>${investment.share_price}</td>
                <td>{investment.transaction_date}</td>
              </tr>
            ))
          ) : (
            <tr>
              <td colSpan="5" className="text-center">
                No investments found.
              </td>
            </tr>
          )}
        </tbody>
      </Table>
    </div>
  );
};

export default AccountBillingTab;
