import React, { useState } from "react";
import { Col, Container, Row, TabContent, TabPane } from "reactstrap";
import CardsPaymentTab from "./cards&paymentTab";
import CreatePropertyTab from "./createPropertyTab";
import FavoritesTab from "./favouritesTab";
import MyListingTab from "./myListingTab";
import MyProfileTab from "./myProfileTab";
import InvestmentProjectTab from "./investmentProjectTab";
import FinancialProjectTab from "./financialProjectTab";
import AllProjectTab from "./allProjectTab";
import AccountBillingTab from "./accountBillingTab";
import PrivacyTab from "./privacyTab.js";
import MyTeamTab from "./myTeamTab";
import AllchannelpartnerTab from "./allchannelpartnerTab";
import AllfrenchisepartnerTab from "./allfrenchisepartnerTab";
import EditProfileTab from "./editProfileTab";
import UploadDocumentTab from "./uploadDocumentTab";
import UserDashboardTab from "./userDashboardTab";
import UserPanelSidebar from "./UserPanelSidebar";

const BodyContent = ({ active }) => {
  const [activeTab, setActiveTab] = useState(active);

  return (
    <section className='user-dashboard small-section'>
      <Container>
        <Row>
          <UserPanelSidebar activeTab={activeTab} setActiveTab={setActiveTab} />
          <Col lg='9'>
            <TabContent activeTab={activeTab}>
              <TabPane tabId='Dashboard'>
                <UserDashboardTab />
              </TabPane>
            </TabContent>
            <TabContent activeTab={activeTab}>
              <TabPane tabId='Listing'>
                <MyListingTab />
              </TabPane>
            </TabContent>
            <TabContent activeTab={activeTab}>
              <TabPane tabId='CreateProperty'>
                <CreatePropertyTab />
              </TabPane>
            </TabContent>
            <TabContent activeTab={activeTab}>
              <TabPane tabId='EditProfile'>
                <EditProfileTab />
              </TabPane>
            </TabContent>
			<TabContent activeTab={activeTab}>
              <TabPane tabId='UploadDocument'>
                <UploadDocumentTab />
              </TabPane>
            </TabContent>
			<TabContent activeTab={activeTab}>
              <TabPane tabId='Profile'>
                <MyProfileTab activeTab={activeTab} setActiveTab={setActiveTab} />
              </TabPane>
            </TabContent>
			
			<TabContent activeTab={activeTab}>
              <TabPane tabId='AllProject'>
                <AllProjectTab />
              </TabPane>
            </TabContent>
			
			
			<TabContent activeTab={activeTab}>
              <TabPane tabId='AccountBilling'>
                <AccountBillingTab />
              </TabPane>
            </TabContent>
			
			<TabContent activeTab={activeTab}>
              <TabPane tabId='FinancialProject'>
                <FinancialProjectTab />
              </TabPane>
            </TabContent>
			
			<TabContent activeTab={activeTab}>
              <TabPane tabId='InvestmentProject'>
                <InvestmentProjectTab />
              </TabPane>
            </TabContent>
			
			  <TabContent activeTab={activeTab}>
			 <TabPane tabId="MyTeam">
                <MyTeamTab />
              </TabPane>
			   </TabContent>	
			   
			  <TabContent activeTab={activeTab}>
			 <TabPane tabId="Allchannelpartner">
                <AllchannelpartnerTab />
              </TabPane>
			   </TabContent>	
			   
			    <TabContent activeTab={activeTab}>
			 <TabPane tabId="Allfrenchisepartner">
                <AllfrenchisepartnerTab />
              </TabPane>
			   </TabContent>	
			   
            <TabContent activeTab={activeTab}>
              <TabPane tabId='Favorites'>
                <FavoritesTab />
              </TabPane>
            </TabContent>
            <TabContent activeTab={activeTab}>
              <TabPane tabId='Paymnet'>
                <CardsPaymentTab />
              </TabPane>
            </TabContent>
            <TabContent activeTab={activeTab}>
              <TabPane tabId='Privacy'>
                <PrivacyTab />
              </TabPane>
            </TabContent>
          </Col>
        </Row>
      </Container>
    </section>
  );
};

export default BodyContent;
