import React, { useEffect, useState } from "react";
import { Row, Col, Alert } from "reactstrap";
import axios from 'axios';
import Link from 'next/link';  
import './projects.css';  

const InvestmentProjectTab = () => {
  const BASE_URL = process.env.NEXT_PUBLIC_BASE_URL;
  const [getInvestments, setInvestments] = useState([]);  
  const [successMessage, setSuccessMessage] = useState("");
  const [errorMessage, setErrorMessage] = useState("");

  useEffect(() => {
    const fetchInvestments = async () => {
      try {
        const token = localStorage.getItem("token");
        if (!token) {
          setErrorMessage("You need to be logged in to view investments.");
          return;
        }

        const response = await axios.post(
          `${BASE_URL}/investments`, 
          {}, 
          {
            headers: { Authorization: `Bearer ${token}` },
          }
        );

        setInvestments(response.data.data);
      } catch (error) {
        console.error("Error fetching investments:", error);
        setErrorMessage("Error fetching investments: " + (error.response?.data?.message || "Unknown error occurred."));
      }
    };

    fetchInvestments();
  }, []);

  return (
    <div className="dashboard-content">
      <div className="projects-title">
        <h2>My Investments</h2>
      </div>

      <div className="my-projects">
        {successMessage && <Alert color="success">{successMessage}</Alert>}
        {errorMessage && <Alert color="danger">{errorMessage}</Alert>}

        <div className="projects-listing">
          <Row>
            {getInvestments.length > 0 ? (
              getInvestments.map(investment => ( 
                <Col md="4" key={investment.id} className="mb-4">
                   <div className="project-card">
                    <div className="project-image mb-3">
                      <img src={investment.project.image_url} alt={investment.project.name} className="img-fluid" />
                    </div>

                    <div className="project-minimum-investment">
                      <strong>Project Name: </strong>{investment.project.name}
                    </div>
					<div className="project-minimum-investment">
                      <strong>Amount Invested: </strong>${investment.amount_invested}
                    </div>

                    

                    {/* View Project Progress Button */}
                    <Link href={`/pages/other-pages/progress/${investment.project.id}`}>
                      <button className="btn btn-primary btn-sm mt-2">
                        View Details
                      </button>
                    </Link>

                  </div>
                </Col>
              ))
            ) : (
              <Col md="12">
                <p>No investments found.</p>
              </Col>
            )}
          </Row>
        </div>
      </div>
    </div>
  );
};

export default InvestmentProjectTab;
