 
import React, { Fragment, useEffect, useState } from "react";
import { Container } from "reactstrap";
import Img from "../../utils/BackgroundImageRatio";
import { useRouter } from "next/navigation";
import { usePathname } from "next/navigation";

const Breadcrumb = ({ right }) => {
  const pathname = usePathname();
  const router = useRouter();
  const [path, setPath] = useState();
  useEffect(() => {
    setPath(pathname.split("/"));
  }, [router.pathname]);
  return (
    <section className="breadcrumb-section grea-breadcrumb p-0 ">
      <div className="customOverlay"></div>
      <Img src="/assets/images/inner-background.jpg" className="bg-img img-fluid" alt="" />
      <Container>
        <div className={`breadcrumb-content ${right ? "breadcrumb-right" : ""}`}>
          <div>
           <h2>
  {path && path[path.length - 1] === "user-dashboard"
    ? "Customer Dashboard"
    : "Customer Login"}
</h2>
{/*<nav aria-label="breadcrumb" className="theme-breadcrumb">
  <ol className="breadcrumb">
    {path?.map((data, i) => (
      <Fragment key={i}>
        {data && (
          <li className="breadcrumb-item">
            <a>
              {data === "user-dashboard" ? "Franchise/Partner Dashboard" : data.replaceAll("-", " ")}
            </a>
          </li>
        )}
      </Fragment>
    ))}
  </ol>
</nav>*/}


          </div>
        </div>
      </Container>
    </section>
  );
};

export default Breadcrumb;
