/**
 * It returns a div with a div inside it, which has an image, a heading, a subheading, and a button
 * @returns A div with a div inside of it.
 */
import Link from "next/link";
import React from "react";
import { Container } from "reactstrap";


const HeroSection = ({ img, mainTitle }) => {
  return (
    <Container >
      <div className="content">
        <div className="assatz-logo">
          <img src={img} className="img-fluid m-0" alt="" />
        </div>
        <Link href="/pages/other-pages/login" className="btn assatz-btn">
        {mainTitle}
        </Link>
      </div>
    </Container>
  );
};

export default HeroSection;
