/**
 * It returns a div with a div inside it, which has an image, a heading, a subheading, and a button
 * @returns A div with a div inside of it.
 */
import Link from "next/link";
import React from "react";
import { SubmitProperty, WantToBuyOrRentHome } from "@/constValues/constValues";
import { Container } from "reactstrap";


const HomeSliderContent = ({ img, mainTitle }) => {
  return (
    <div>
      <div className="home-content">
        <div>
          <div className="sliderImage">
            <img src={img} className="img-fluid m-0" alt="" />

            <div className="sliderContent">
              <Container >
                <h6>{WantToBuyOrRentHome}</h6>
                <h1>{mainTitle}</h1>
                {/* <Link href="/pages/other-pages/login" className="btn btn-gradient">
            {SubmitProperty}
          </Link> */}
              </Container>

            </div>

          </div>

        </div>
      </div>
    </div>
  );
};

export default HomeSliderContent;
