import React, { useState, useEffect } from "react";
import { Alert, Row, Col, Button, Form, FormGroup, Label, Input } from "reactstrap";
import axios from "axios";

const UploadDocumentTab = () => {
  const BASE_URL = process.env.NEXT_PUBLIC_BASE_URL;
  const [aadharFile, setAadharFile] = useState(null);
  const [panFile, setPanFile] = useState(null);
  const [gstFile, setGstFile] = useState(null); // GST certificate file state
  const [companypanFile, setCompanypanFile] = useState(null); // GST certificate file state
  const [gstNumber, setGstNumber] = useState(""); // PAN number state
  const [panNumber, setPanNumber] = useState(""); // PAN number state
  const [aadharPreview, setAadharPreview] = useState(null);
  const [panPreview, setPanPreview] = useState(null);
  const [gstPreview, setGstPreview] = useState(null); // GST certificate preview
  const [companypanPreview, setCompanypanPreview] = useState(null); // GST certificate preview
  const [successMessage, setSuccessMessage] = useState("");
  const [errorMessage, setErrorMessage] = useState("");

  useEffect(() => {
    const fetchExistingDocuments = async () => {
      const token = localStorage.getItem("token");
      if (!token) {
        setErrorMessage("You need to be logged in to view your documents.");
        return;
      }

      try {
        const response = await axios.post(`${BASE_URL}/edit/profile`, {},{
          headers: {
            Authorization: `Bearer ${token}`,
          },
        });
        if (response.data.message === "Unauthenticated.") {
          localStorage.clear();
          window.location.href = '/';
        }
        const { aadhar_card_doc_url, pan_card_doc_url, company_gst_certificate_doc_url, company_pan_doc_url,pan,company_gst } = response.data.data;
        if (aadhar_card_doc_url) setAadharPreview(aadhar_card_doc_url);
        if (pan_card_doc_url) setPanPreview(pan_card_doc_url);
        if (company_gst_certificate_doc_url) setGstPreview(company_gst_certificate_doc_url); // Set GST certificate preview
        if (company_pan_doc_url) setCompanypanPreview(company_pan_doc_url); // Set GST certificate preview
		if (pan) setPanNumber(pan);
		if (company_gst) setGstNumber(company_gst);
      } catch (error) {
        console.error("Error fetching documents:", error);
        setErrorMessage("Error fetching documents: " + (error.response?.data?.message || "Unknown error occurred."));
        if (error.response && error.response.data && error.response.data.message === 'Unauthenticated.') {
          localStorage.clear();
          window.location.href = '/';
        }
      }
    };

    fetchExistingDocuments();
  }, [BASE_URL]);

  const handleFileChange = (e, setFile, setPreview) => {
    const file = e.target.files[0];
    if (file) {
      setFile(file);
      setPreview(URL.createObjectURL(file)); // Generate preview URL for the newly selected file
    }
  };

  const handleFileUpload = async (e) => {
    e.preventDefault();

    const token = localStorage.getItem("token");
    if (!token) {
      setErrorMessage("You need to be logged in to upload documents.");
      return;
    }

   /*  if (!aadharFile && !panFile && !gstFile) {
      setErrorMessage("Please select at least one document to upload.");
      return;
    } */

    const formData = new FormData();
    if (aadharFile) formData.append("aadhar_card", aadharFile);
    if (panFile) formData.append("pan_card", panFile);
    if (gstFile) formData.append("company_gst_certificate", gstFile); // Append GST certificate file
    if (companypanFile) formData.append("company_pan", companypanFile); // Append GST certificate file
    if (panNumber) formData.append("pan", panNumber); // Append GST certificate file
    if (gstNumber) formData.append("company_gst", gstNumber); // Append GST certificate file
	
    try {
      const response = await axios.post(`${BASE_URL}/upload/documents`, formData, {
        headers: {
          Authorization: `Bearer ${token}`,
          "Content-Type": "multipart/form-data",
        },
      });
      if (response.data.message === "Unauthenticated.") {
        localStorage.clear();
        window.location.href = '/';
      }
      const { aadhar_card_doc_url, pan_card_doc_url, company_gst_certificate_doc_url, company_pan_doc_url,pan,company_gst } = response.data.data;
      setSuccessMessage("Documents uploaded successfully!");
      setAadharFile(null);
      setPanFile(null);
      setGstFile(null); // Reset GST certificate file
      setCompanypanFile(null); // Reset GST certificate file
      if (aadhar_card_doc_url) setAadharPreview(aadhar_card_doc_url);
      if (pan_card_doc_url) setPanPreview(pan_card_doc_url);
      if (company_gst_certificate_doc_url) setGstPreview(company_gst_certificate_doc_url); // Set new GST certificate URL
      if (company_pan_doc_url) setCompanypanPreview(company_pan_doc_url); // Set new GST certificate URL
		if (pan) setPanNumber(pan);
		if (company_gst) setGstNumber(company_gst);
    } catch (error) {
      console.error("Error uploading documents:", error);
      setErrorMessage("Error uploading documents: " + (error.response?.data?.message || "Unknown error occurred."));
      if (error.response && error.response.data && error.response.data.message === 'Unauthenticated.') {
        localStorage.clear();
        window.location.href = '/';
      }
    }
  };

  return (
    <div className="dashboard-content">
      <div className="upload-documents" id="upload-documents">
        {successMessage && <Alert color="success">{successMessage}</Alert>}
        {errorMessage && <Alert color="danger">{errorMessage}</Alert>}
        <div className="common-card">
          <h5>Upload Documents</h5>
          <Form onSubmit={handleFileUpload}>
            <Row>
			 <Col md="6">
                <FormGroup>
                  <Label for="gstCertificate">Upload Company GST Certificate</Label>
                  <Input
                    type="file"
                    id="gstCertificate"
                    onChange={(e) => handleFileChange(e, setGstFile, setGstPreview)}
                    accept=".pdf,.jpg,.jpeg,.png"
                  />
                  {gstPreview && (
                    <div className="file-preview mt-2">
                      <a
                        href={gstPreview}
                        target="_blank"
                        rel="noopener noreferrer"
                      >
                        <img
                          src={gstPreview}
                          alt="GST Certificate Preview"
                          style={{
                            maxWidth: "100%",
                            maxHeight: "150px",
                            border: "1px solid #ddd",
                            padding: "5px",
                          }}
                        />
                      </a>
                    </div>
                  )} 
                </FormGroup>
              </Col>
			  
			  <Col md="6">
                <FormGroup>
                  <Label for="gstcompany_pan">Upload Company PAN</Label>
                  <Input
                    type="file"
                    id="gstcompany_pan"
                    onChange={(e) => handleFileChange(e, setCompanypanFile, setCompanypanPreview)}
                    accept=".pdf,.jpg,.jpeg,.png"
                  />
                  {companypanPreview && (
                    <div className="file-preview mt-2">
                      <a
                        href={companypanPreview}
                        target="_blank"
                        rel="noopener noreferrer"
                      >
                        <img
                          src={companypanPreview}
                          alt="Pan Preview"
                          style={{
                            maxWidth: "100%",
                            maxHeight: "150px",
                            border: "1px solid #ddd",
                            padding: "5px",
                          }}
                        />
                      </a>
                    </div>
                  )}
                </FormGroup>
              </Col>
             
			<Col md="6">
                <FormGroup>
                  <Label for="panCard">Upload PAN Card</Label>
                  <Input
                    type="file"
                    id="panCard"
                    onChange={(e) => handleFileChange(e, setPanFile, setPanPreview)}
                    accept=".pdf,.jpg,.jpeg,.png"
                  />
                  {panPreview && (
                    <div className="file-preview mt-2">
                      <a
                        href={panPreview}
                        target="_blank"
                        rel="noopener noreferrer"
                      >
                        <img
                          src={panPreview}
                          alt="PAN Preview"
                          style={{
                            maxWidth: "100%",
                            maxHeight: "150px",
                            border: "1px solid #ddd",
                            padding: "5px",
                          }}
                        />
                      </a>
                    </div>
                  )}
                </FormGroup>
              </Col>
              <Col md="6">
                <FormGroup>
                  <Label for="aadharCard">Upload Aadhaar Card</Label>
                  <Input
                    type="file"
                    id="aadharCard"
                    onChange={(e) => handleFileChange(e, setAadharFile, setAadharPreview)}
                    accept=".pdf,.jpg,.jpeg,.png"
                  />
                  {aadharPreview && (
                    <div className="file-preview mt-2">
                      <a
                        href={aadharPreview}
                        target="_blank"
                        rel="noopener noreferrer"
                      >
                        <img
                          src={aadharPreview}
                          alt="Aadhaar Preview"
                          style={{
                            maxWidth: "100%",
                            maxHeight: "150px",
                            border: "1px solid #ddd",
                            padding: "5px",
                          }}
                        />
                      </a>
                    </div>
                  )}
                </FormGroup>
              </Col>
              
             
            </Row>
            <Button type="submit" color="primary">
              Upload Documents
            </Button>
          </Form>
        </div>
      </div>
    </div>
  );
};

export default UploadDocumentTab;
