import React, { useEffect, useState } from "react";
import { Camera } from "react-feather";
import { Col, Nav, NavItem, NavLink } from "reactstrap";
import axios from "axios";
import LogoutButton from "../../common/LogoutButton";


const UserPanelSidebar = ({ activeTab, setActiveTab }) => {
  const [profileData, setProfileData] = useState(null); // State to store profile data
  const [errorMessage, setErrorMessage] = useState(""); // State for error handling
  const [loading, setLoading] = useState(false); // State for loading indicator while uploading
	const [userRole, setUserRole] = useState(null);
  // Fetch user profile data when the component mounts
  useEffect(() => {
    const fetchUserProfile = async () => {
      const token = localStorage.getItem("token"); // Get token from localStorage

      if (!token) {
        setErrorMessage("You need to be logged in to view your profile.");
        return;
      }

      try {
        // Fetch user profile data from the API
        const response = await axios.post(
          `${process.env.NEXT_PUBLIC_BASE_URL}/edit/profile`,
          {},
          {
            headers: {
              Authorization: `Bearer ${token}`,
            },
          }
        );
		console.log(response);
		if (response.data.message === "Unauthenticated.") {
        localStorage.clear();
        window.location.href = '/';
      }
        // Set profile data to state
        setProfileData(response.data.data);
      } catch (error) {
        console.error("Error fetching user profile:", error);
        setErrorMessage("Error fetching profile data.");
		if (error.response && error.response.data && error.response.data.message === 'Unauthenticated.') {
        localStorage.clear();
        window.location.href = '/';
      }
      }
    };

    fetchUserProfile(); // Call the function to fetch the user profile
  }, []);


 useEffect(() => {
    // Get user data from localStorage and check role
    const user = JSON.parse(localStorage.getItem("user"));
    if (user) {
      setUserRole(user.role_name);
    }
  }, []);
  
  
  // Handle file input change for uploading profile picture
  const handleFileChange = async (event) => {
    const file = event.target.files[0]; // Get the selected file

    if (!file) return; // Return if no file is selected

    setLoading(true); // Set loading state to true while uploading

    const formData = new FormData();
    formData.append("profile_picture", file); // Append the file to FormData

    const token = localStorage.getItem("token"); // Get token from localStorage

    try {
      // Upload the profile picture
      const response = await axios.post(
        `${process.env.NEXT_PUBLIC_BASE_URL}/upload/profile-picture`,
        formData,
        {
          headers: {
            "Content-Type": "multipart/form-data",
            Authorization: `Bearer ${token}`,
          },
        }
      );
if (response.data.message === "Unauthenticated.") {
        localStorage.clear();
        window.location.href = '/';
      }
      // After successful upload, update profile data with the new picture
      setProfileData((prevData) => ({
        ...prevData,
        profile_picture_url: response.data.profile_picture, // Update the profile_picture_url field
      }));

      setLoading(false); // Set loading state to false after upload
    } catch (error) {
      console.error("Error uploading profile picture:", error);
      setErrorMessage("Error uploading profile picture."); // Set error message on failure
      setLoading(false); // Set loading state to false even on failure
	  if (error.response && error.response.data && error.response.data.message === 'Unauthenticated.') {
        localStorage.clear();
        window.location.href = '/';
      }
    }
  };

  if (errorMessage) {
    return <div className="error-message">{errorMessage}</div>; // Show error message if there's any
  }

  if (!profileData) {
    return <div>Loading...</div>; // Show loading message if data is not yet fetched
  }

  return (
    <Col lg="3">
      <div className="sidebar-user sticky-cls">
        <div className="user-profile">
          <div className="media media-body">
            <div className="change-pic">
              {/* Display the profile picture or fallback if not available */}
              <img
                src={profileData.profile_picture_url || "/assets/images/avatar/3.jpg"}
                className="img-fluid update_img"
                alt="Profile"
              />
			  
             
              <div className="change-hover">
                <button type="button" className="btn">
                  <Camera />
                </button>
                {/* Input for selecting the new profile picture */}
                <input
                  className="updateimg"
                  type="file"
                  name="img"
                  onChange={handleFileChange} // Handle file change to upload the new picture
                  disabled={loading} // Disable the input while the file is uploading
                />
              </div>
			   <div className="mt-3">
              {/* Display the user's name, email, and phone */}
			   <p className="text-justify"><b>My ID - {profileData.referral_id}</b></p>
              <h5>
                {profileData.first_name} {profileData.last_name}
              </h5>
              <h6 className="font-roboto">{profileData.email}</h6>
              <h6 className="font-roboto mb-0">{profileData.mobile}</h6>
            </div>
            </div>
           
          </div>
          {/* <div className="connected-social">
            <h6>Connect with</h6>
            <ul className="agent-social">
              <li>
                <a href="https://www.facebook.com/" className="facebook">
                  <i className="fab fa-facebook-f"></i>
                </a>
              </li>
              <li>
                <a href="https://twitter.com/" className="twitter">
                  <i className="fab fa-twitter"></i>
                </a>
              </li>
              <li>
                <a href="https://account.google.com" className="google">
                  <i className="fab fa-google"></i>
                </a>
              </li>
              <li>
                <a href="https://www.linkedin.com/" className="linkedin">
                  <i className="fab fa-linkedin-in"></i>
                </a>
              </li>
            </ul>
          </div> */}
        </div>

        {/* Sidebar Navigation */}
        <div className="dashboard-list">
          <Nav tabs className="right-line-tab">
            {/* <NavItem>
              <NavLink
                className={activeTab === "Dashboard" ? "active" : ""}
                onClick={() => setActiveTab("Dashboard")}
              >
                Dashboard
              </NavLink>
            </NavItem>
            <NavItem>
              <NavLink
                className={activeTab === "CreateProperty" ? "active" : ""}
                onClick={() => setActiveTab("CreateProperty")}
              >
                Create Property
              </NavLink>
            </NavItem> */}
            <NavItem>
              <NavLink
                className={activeTab === "EditProfile" ? "active" : ""}
                onClick={() => setActiveTab("EditProfile")}
              >
                Edit Profile
              </NavLink>
            </NavItem>
			{/*<NavItem>
              <NavLink
                className={activeTab === "UploadDocument" ? "active" : ""}
                onClick={() => setActiveTab("UploadDocument")}
              >
                Upload Documents
              </NavLink>
            </NavItem>*/}
			
            <NavItem>
              <NavLink
                className={activeTab === "Profile" ? "active" : ""}
                onClick={() => setActiveTab("Profile")}
              >
                View Profile
              </NavLink>
            </NavItem>
			
			
			  <NavItem>
              <NavLink className={activeTab === "AllProject" ? "active" : ""}
                onClick={() => setActiveTab("AllProject")}>
               Project Updates
              </NavLink>
            </NavItem>
			
			 <NavItem>
			  <NavLink>
               Investment details
              </NavLink>
            </NavItem>
			
			  <NavItem>
			  <NavLink >
              Financials 
              </NavLink>
            </NavItem>
			
			<NavItem>
			  <NavLink>
              Balance Sheets 
              </NavLink>
            </NavItem>
			 
			 
			 <NavItem>
              <NavLink>
                Account & Billing
              </NavLink>
            </NavItem>
			
			 <NavItem>
              <NavLink>
               My Investments
              </NavLink>
            </NavItem>
            
            {/*  <NavItem>
                <NavLink
                  className={activeTab === "MyTeam" ? "active" : ""}
                  onClick={() => setActiveTab("MyTeam")}
                >
                  My Team
                </NavLink>
              </NavItem>
			  
			  {userRole === "superadmin" && (
				<>
				  <NavItem>
					<NavLink
					  className={activeTab === "Allchannelpartner" ? "active" : ""}
					  onClick={() => setActiveTab("Allchannelpartner")}
					>
					  All Channel Partners
					</NavLink>
				  </NavItem>

				  <NavItem>
					<NavLink 
					  className={activeTab === "Allfrenchisepartner" ? "active" : ""}
					  onClick={() => setActiveTab("Allfrenchisepartner")}
					>
					  All Franchise Partners
					</NavLink>
				  </NavItem>
				</>
			)}*/}
				
            {/*  <NavItem>
              <NavLink
                className={activeTab === "Favorites" ? "active" : ""}
                onClick={() => setActiveTab("Favorites")}
              >
                Favorites
              </NavLink>
            </NavItem>
            <NavItem>
              <NavLink
                className={activeTab === "Paymnet" ? "active" : ""}
                onClick={() => setActiveTab("Paymnet")}
              >
                Cards & Payment
              </NavLink>
            </NavItem>
            <NavItem>
              <NavLink
                className={activeTab === "Privacy" ? "active" : ""}
                onClick={() => setActiveTab("Privacy")}
              >
                Privacy
              </NavLink>
            </NavItem> */}
          </Nav>
		  &nbsp; &nbsp; &nbsp;<LogoutButton />
        </div>
      </div>
    </Col>
  );
};

export default UserPanelSidebar;
