import React, { useEffect, useState } from "react";
import { Button, Col, Form, Input, Label, Row, Alert, ListGroup, ListGroupItem } from "reactstrap";
import axios from 'axios';

const EditProfileTab = () => {
  const [inputs, setInputs] = useState({});
  const [inputs2, setInputs2] = useState({});
  const [countries, setCountries] = useState([]);
  const [states, setStates] = useState([]);
  const [successMessage, setSuccessMessage] = useState("");
  const [errorMessage, setErrorMessage] = useState("");
  const [errorMessage2, setErrorMessage2] = useState("");
  const [referralSuggestions, setReferralSuggestions] = useState([]);
  const [isReferralLoading, setIsReferralLoading] = useState(false);
  const BASE_URL = process.env.NEXT_PUBLIC_BASE_URL;
const [profileDetail, setProfileDetail] = useState({});
  useEffect(() => {
    const fetchUserProfile = async () => {
      try {
        const token = localStorage.getItem('token');
        const response = await axios.post(`${BASE_URL}/edit/profile`, {}, {
          headers: {
            'Authorization': `Bearer ${token}`,
          },
        });
        setInputs(response.data.data);
        setInputs2(response.data.data);
      } catch (error) {
        console.error("Error fetching user profile:", error);
        setErrorMessage("Error fetching profile data.");
      }
    };

    const fetchCountries = async () => {
      try {
        const response = await axios.post(`${BASE_URL}/countries`);
        setCountries(response.data.data);
      } catch (error) {
        console.error("Error fetching countries:", error);
      }
    };

    fetchCountries();
    fetchUserProfile();
  }, []);

  useEffect(() => {
    if (inputs.country_id) {
      const fetchStates = async () => {
        try {
          const response = await axios.post(`${BASE_URL}/states`, { country_id: inputs.country_id });
          setStates(response.data.data);
        } catch (error) {
          console.error("Error fetching states:", error);
        }
      };

      fetchStates();
    }
  }, [inputs.country_id]);

  const fetchReferralSuggestions = async (referralId) => {
  if (!referralId) {
    setReferralSuggestions([]);
    setErrorMessage2("");
    return;
  }

  setIsReferralLoading(true);
  try {
    const token = localStorage.getItem('token');
    const response = await axios.post(
      `${BASE_URL}/referralidsuggestions`,
      { my_referral_id: referralId },
      {
        headers: {
          'Authorization': `Bearer ${token}`,
          'Content-Type': 'application/json',
        },
      }
    );

    const suggestions = response.data.data || [];
    setReferralSuggestions(suggestions);

    // Show error message if no suggestions are found
    if (suggestions.length === 0) {
      setErrorMessage2("Invalid referral ID.");
    } else {
      setErrorMessage2("");
    }
  } catch (error) {
    console.error("Error fetching referral suggestions:", error);
    setReferralSuggestions([]);
    setErrorMessage2("Invalid referral ID.");
  } finally {
    setIsReferralLoading(false);
  }
};

  const handleChange = (event) => {
    const { name, value } = event.target;
    setInputs((values) => ({ ...values, [name]: value }));

    if (name === "my_referral_id") {
      fetchReferralSuggestions(value);
    }
  };

  const handleReferralSelect = (referral) => {
    setInputs((prevInputs) => ({
      ...prevInputs,
      my_referral_id: referral.referral_id,
    }));
    setReferralSuggestions([]);
	setErrorMessage2("");
  };

  const handleSubmit = async (event) => {
    event.preventDefault();
    setSuccessMessage("");
    setErrorMessage("");

    try {
      const token = localStorage.getItem('token');
      const response = await axios.post(`${BASE_URL}/update/profile`, inputs, {
        headers: {
          'Authorization': `Bearer ${token}`,
          'Content-Type': 'application/json',
        },
      });
//console.log(response.data);
      if (response.data) {
		  localStorage.setItem('user', JSON.stringify(response.data.data));
        setProfileDetail((prev) => ({ ...prev, ...inputs }));
        setSuccessMessage("Profile updated successfully!");
		 setTimeout(() => {
        window.location.reload(); // Reload the page after a short delay
      }, 1500); // Optional delay for user to see the success message
      }
    } catch (error) {
      console.error("Error updating profile:", error);
      setErrorMessage("Error updating profile: " + (error.response?.data?.message || "Unknown error occurred."));
    }
  };

  return (
    <div className="edit-profile-tab">
      {successMessage && <Alert color="success">{successMessage}</Alert>}
      {errorMessage && <Alert color="danger">{errorMessage}</Alert>}
     <Form id="edit-profile-form" onSubmit={handleSubmit}>
              <Row className="gx-3">

                {/* Personal Information Section */}
                <Col md="12" className="form-group"  style={{ backgroundColor: '#f8f9fa', padding: '15px', borderRadius: '8px' }}>
					  <h5 style={{ margin: 0 }}>Personal Information</h5>
									</Col>
				 

               
                <Col md="6" className="form-group">
                  <Label htmlFor="title">Title</Label>
                 <select
					  name="title"
					  className="form-control"
					  value={inputs.title || ""} // Default value is 'Mr' if 'title' is not provided
					  onChange={handleChange}
					>
					<option value="">Select Title</option>
					  <option value="Mr">Mr</option>
					  <option value="Ms">Ms</option>
					</select>
                </Col>
                <Col md="6" className="form-group">
                  <Label htmlFor="first_name">First Name</Label>
                  <Input name="first_name" type="text" className="form-control" value={inputs.first_name || ""} onChange={handleChange} />
                </Col>
                <Col md="6" className="form-group">
                  <Label htmlFor="middle_name">Middle Name</Label>
                  <Input name="middle_name" type="text" className="form-control" value={inputs.middle_name || ""} onChange={handleChange} />
                </Col>
                <Col md="6" className="form-group">
                  <Label htmlFor="last_name">Last Name</Label>
                  <Input name="last_name" type="text" className="form-control" value={inputs.last_name || ""} onChange={handleChange} />
                </Col>

                {/* Father's Name and Contact Section */}
                <Col md="6" className="form-group">
                  <Label htmlFor="father_name">Father's Name</Label>
                  <Input name="father_name" type="text" className="form-control" value={inputs.father_name || ""} onChange={handleChange} />
                </Col>
                <Col md="6" className="form-group">
                  <Label htmlFor="mobile">Mobile</Label>
                  <Input name="mobile" type="text"  className="form-control bg-light" value={inputs.mobile || ""} onChange={handleChange} />
                </Col>
                <Col md="6" className="form-group">
                  <Label htmlFor="email">Email</Label>
                  <Input name="email" type="email" className={`form-control ${inputs2.my_referral_id ? "bg-light" : ""}`}  readOnly={!!inputs2.email} value={inputs.email || ""} onChange={handleChange} />
                </Col>
                <Col md="6" className="form-group">
                  <Label htmlFor="address">Address</Label>
                  <Input name="address" type="text" className="form-control" value={inputs.address || ""} onChange={handleChange} />
                </Col>

                {/* Location Section */}
                <Col md="6" className="form-group">
                  <Label htmlFor="country_id">Country</Label>
                  <select name="country_id" className="form-control" value={inputs.country_id || ""} onChange={handleChange}>
                    <option value="">Select Country</option>
                    {countries.map((country) => (
                      <option key={country.country_id} value={country.country_id}>{country.name}</option>
                    ))}
                  </select>
                </Col>
                <Col md="6" className="form-group">
                  <Label htmlFor="state_id">State</Label>
                  <select name="state_id" className="form-control" value={inputs.state_id || ""} onChange={handleChange}>
                    <option value="">Select State</option>
                    {states.map((state) => (
                      <option key={state.state_id} value={state.state_id}>{state.name}</option>
                    ))}
                  </select>
                </Col>
                <Col md="12" className="form-group">
                  <Label htmlFor="city">City</Label>
                  <Input name="city" type="text" className="form-control" value={inputs.city || ""} onChange={handleChange} />
                </Col>

                {/* Additional Information Section 
                <Col md="6" className="form-group">
                  <Label htmlFor="years_of_exp">Years of  Experience in Real Estate</Label>
                  <Input name="years_of_exp" type="number" className="form-control" value={inputs.years_of_exp || ""} onChange={handleChange} />
                </Col>
				 <Col md="6" className="form-group">
                  <Label htmlFor="education_qualification">Highest Education Qualification</Label>
                 <select
					  name="education_qualification"
					  className="form-control"
					  value={inputs.education_qualification || ""} // Default value is empty if no value is set
					  onChange={handleChange}
					>
					  <option value="">Select Qualification</option> 
					  <option value="Masters">Masters</option>
					  <option value="Graduate">Graduate</option>
					  <option value="Diploma">Diploma</option>
					  <option value="High School">High School</option>
					</select>

                </Col>*/}
				
                <Col md="6" className="form-group">
                  <Label htmlFor="company_name">Company Name</Label>
                  <Input name="company_name" type="text" className="form-control" value={inputs.company_name || ""} onChange={handleChange} />
                </Col>
                <Col md="6" className="form-group">
                  <Label htmlFor="company_gst">Company GST No.</Label>
                  <Input name="company_gst" type="text" className="form-control" value={inputs.company_gst || ""} onChange={handleChange} />
                </Col>
				<Col md="6" className="form-group">
                  <Label htmlFor="company_pan_number">Company PAN No.</Label>
                  <Input name="company_pan_number" type="text" className="form-control" value={inputs.company_pan_number || ""} onChange={handleChange} />
                </Col>
				
                

                <Col md="12" className="form-group"  style={{ backgroundColor: '#f8f9fa', padding: '15px', borderRadius: '8px' }}>
  <h5 style={{ margin: 0 }}>Nominee Details</h5>
                </Col>

                {/* Nominee Details Section */}
                <Col md="6" className="form-group">
                  <Label htmlFor="nominee_name">Nominee Name</Label>
                  <Input name="nominee_name" type="text" className="form-control" value={inputs.nominee_name || ""} onChange={handleChange} />
                </Col>
                <Col md="6" className="form-group">
                  <Label htmlFor="nominee_relationship">Nominee Relationship</Label>
                  <Input name="nominee_relationship" type="text" className="form-control" value={inputs.nominee_relationship || ""} onChange={handleChange} />
                </Col>
                <Col md="6" className="form-group">
                  <Label htmlFor="nominee_contact">Nominee Contact No.</Label>
                  <Input name="nominee_contact" type="text" className="form-control" value={inputs.nominee_contact || ""} onChange={handleChange} />
                </Col>
				<Col md="12" className="form-group" style={{ backgroundColor: '#f8f9fa', padding: '15px', borderRadius: '8px' }}>
  <h5 style={{ margin: 0 }}>Bank Details</h5>
</Col>
                {/* Bank Details Section */}
                <Col md="6" className="form-group">
                  <Label htmlFor="bank_name">Bank Name</Label>
                  <Input name="bank_name" type="text" className="form-control" value={inputs.bank_name || ""} onChange={handleChange} />
                </Col>
                <Col md="6" className="form-group">
                  <Label htmlFor="account_number">Account Number</Label>
                  <Input name="account_number" type="text" className="form-control" value={inputs.account_number || ""} onChange={handleChange} />
                </Col>
                <Col md="6" className="form-group">
                  <Label htmlFor="ifsc_code">IFSC Code</Label>
                  <Input name="ifsc_code" type="text" className="form-control" value={inputs.ifsc_code || ""} onChange={handleChange} />
                </Col>
                <Col md="6" className="form-group">
                  <Label htmlFor="account_type">Account Type</Label>
                  <select name="account_type" className="form-control" value={inputs.account_type || ""} onChange={handleChange}>
                    <option value="Savings">Savings</option>
                    <option value="Current">Current</option>
                  </select>
                </Col> 

                {/* Identification Section */}
                <Col md="6" className="form-group">
                  <Label htmlFor="pan">PAN</Label>
                  <Input name="pan" type="text" className="form-control" value={inputs.pan || ""} onChange={handleChange} />
                </Col>
                <Col md="6" className="form-group">
                  <Label htmlFor="aadhar_number">Aadhar Number</Label>
                  <Input name="aadhar_number" type="text" className="form-control" value={inputs.aadhar_number || ""} onChange={handleChange} />
                </Col>
				{/* Referral ID Section */}
				
				 <Col md="12" className="form-group">
					  <Label htmlFor="my_referral_id">Referral ID (who have referred you)</Label>
					  <Input
						name="my_referral_id"
						type="text"
						className={`form-control ${inputs2.my_referral_id ? "bg-light" : ""}`} 
						placeholder="Referral ID"
						readOnly={!!inputs2.my_referral_id}
						value={inputs.my_referral_id || ""}
						onChange={handleChange}
					  />
					  {isReferralLoading && <div className="text-center">Loading...</div>}
					  
					  {/* Show error message if no valid suggestions */}
					  {errorMessage2 && referralSuggestions.length === 0 && !isReferralLoading && (
						<div className="text-danger mt-2">{errorMessage2}</div>
					  )}
				</Col>
				<Col md="6" className="form-group">
                   <Button type="submit" className="btn btn-gradient btn-pill" form="edit-profile-form">
              Save changes
            </Button>
           </Col>
               
				
				
              </Row>
            </Form>
    </div>
  );
};

export default EditProfileTab;
