"use client";
import React, { useEffect, Fragment, useState } from "react";
import { User } from "react-feather";
import { Col, Container, Row, Alert } from "reactstrap";
import { useRouter } from 'next/navigation';
import { useDispatch, useSelector } from 'react-redux';
import { setMessage } from '../../../../../redux-toolkit/reducers/loginSlice'; // Updated path
import Breadcrumb from "@/layout/Breadcrumb/Breadcrumb";
import NavbarThree from "@/layout/headers/NavbarThree";
import FooterThree from "@/layout/footers/FooterThree";

const Adminlogin = () => {
  const router = useRouter();
  const BASE_URL = process.env.NEXT_PUBLIC_BASE_URL;

  const dispatch = useDispatch();
  const { message } = useSelector(state => state.login);

  const [email, setEmail] = useState(""); // Added state for email
  const [password, setPassword] = useState(""); // Added state for password

  useEffect(() => {
    // Redirect to the homepage if token exists in localStorage
    const token = localStorage.getItem("token");
    if (token) {
      router.push("/");
    }
  }, [router]);

  const handleLogin = async (e) => {
    e.preventDefault();
    dispatch(setMessage({ text: '', type: '' }));

    try {
      const response = await fetch(`${BASE_URL}/admin-login`, {
        method: 'POST',
        headers: { 'Content-Type': 'application/json' },
        body: JSON.stringify({ email, password }), // Sending email and password for login
      });

      if (response.ok) {
        const data = await response.json();
        
          // Store token and user info in localStorage on successful login
          localStorage.setItem('token', data.token);
          localStorage.setItem('user', JSON.stringify(data.data));
		   dispatch(setMessage({ text: "Login successful!", type: 'success' }));
		   
			router.push('/pages/user-panel/user-dashboard');
        
      } else {
		 
        const errorData = await response.json();
        dispatch(setMessage({ text: errorData.message, type: 'error' }));
      }
    } catch (error) {
		
      console.error("Error logging in:", error);
      dispatch(setMessage({ text: "Login failed, please try again.", type: 'error' }));
    }
  };

  return (
    <Fragment>
      <NavbarThree />
      <Breadcrumb />
      <section className='login-wrap'>
        <Container>
          <Row className='log-in'>
            <Col xl='5' lg='6' md='8' sm='10'>
              <div className='theme-card'>
                <div className='title-3 text-start'>
                  <h2>Admin Log in</h2>
                </div>
                <form onSubmit={handleLogin}>
                  {message.text && (
                    <Alert color={message.type === 'success' ? 'success' : 'danger'}>
                      {message.text}
                    </Alert>
                  )}

                  {/* Email input */}
                  <div className='form-group'>
                    <div className='input-group'>
                      <div className='input-group-prepend'>
                        <div className='input-group-text'>
                          <User />
                        </div>
                      </div>
                      <input
                        type='email'
                        className='form-control'
                        placeholder='Enter Email'
                        value={email}
                        onChange={(e) => setEmail(e.target.value)}
                        required
                      />
                    </div>
                  </div>

                  {/* Password input */}
                  <div className='form-group'>
                    <div className='input-group'>
                      <div className='input-group-prepend'>
                        <div className='input-group-text'>
                          <User />
                        </div>
                      </div>
                      <input
                        type='password'
                        className='form-control'
                        placeholder='Enter Password'
                        value={password}
                        onChange={(e) => setPassword(e.target.value)}
                        required
                      />
                    </div>
                  </div>

                  <div className="d-flex justify-content-center">
                    <button type='submit' className='btn btn-gradient text-center btn-pill me-sm-3 me-2'>
                      Log In
                    </button>
                  </div>
                </form>
              </div>
            </Col>
          </Row>
        </Container>
      </section>
      <FooterThree />
    </Fragment>
  );
};

export default Adminlogin;
