/**
 * It's a function that returns a section with a container, a row, a column, a div, a slider, and a map
 * function that returns a div, a row, two columns, two divs, a link, a span, a h6, a h3, a span, a p,
 * and another link
 * @returns The AboutSection component is being returned.
 */
import Link from "next/link";
import React from "react";
import { Eye, Heart, Mail } from "react-feather";
import Slider from "react-slick";
import { Col, Container, Row } from "reactstrap";
import { Agent, Connect, MeetOurAgent, ViewPortfolio, SecondSectionHeading, SecondSectionLabel } from "@/constValues/constValues";
import { about1 } from "@/data/slickSlider";
import NoSsr from "@/utils/NoSsr";
import SocialAccounts from "../../elements/SocialAccounts";

const SecondSection = ({ value }) => {
  return (
    <section className="about-section newHomeSecond-section slick-between light-bg-two">
      <Container>
        <Row>
          <Col >
            <div className="title-1">
              <span className="label label-gradient">{SecondSectionLabel}</span>
              <h2>{SecondSectionHeading}</h2>
              <hr />
            </div>
            <NoSsr>  
            </NoSsr>
          </Col>

          <Row className="container about-wrap arrow-white" {...about1}>
                {value &&
                  value.map((data, i) => (
                    <Col key={i}    sm="12" lg="6" xl="4"  xxl = "3" >
                      <div className="about-content">
                        <div >
                          <div className="about-image !bg-[#c1c1c1] flex items-center justify-center text-center ">
                            <img src={data.img} className="img-fluid !w-[200px] !shadow-none " alt="" />
                            <div className="about-overlay"></div>
                            <div className="overlay-content">
                              {/* <SocialAccounts /> */}
                              <span>
                                {/* {Connect} */}
                                {data.name}
                                </span>
                            </div>
                          </div>
                        </div>
                        <div>
                          <div className="our-details mt-0">
                            <a href="#0">
                              <h6 className="d-flex">
                                {data.name}
                                {/* <span className="label-heart ms-2">
                                  <Heart />
                                </span> */}
                              </h6>
                            </a>
                            {/* <h3>{data.work}</h3> */}
                            {/* <span className="font-roboto">
                              <Mail className="me-1" />
                              {data.email}
                            </span> */}
                            {/* <p className="font-roboto">{data.detail}</p> */}
                            <a href="#0" className="btn btn-gradient btn-pill mt-2 !flex items-center justify-center !w-fit ">
                              <Eye />
                              {/* {ViewPortfolio} */}
                              View Detail
                            </a>
                          </div>
                        </div>
                      </div>
                    </Col>
                  ))}
              </Row>
        </Row>
      </Container>
    </section>
  );
};

export default SecondSection;
