import Link from "next/link";
import React, { useEffect, useState } from "react";
import { Container } from "reactstrap";

const HeroSection = ({ img, mainTitle }) => {
  const [isLoggedIn, setIsLoggedIn] = useState(false);

  useEffect(() => {
    // localStorage से token चेक करें
    const token = localStorage.getItem("token");
    if (token) {
      setIsLoggedIn(true);
    }
  }, []);

  return (
    <Container>
      <div className="content">
        <div className="assatz-logo">
          <img src={img} className="img-fluid m-0" alt="" />
        </div>
        <Link href={isLoggedIn ? "/pages/user-panel/user-dashboard" : "/pages/other-pages/login"} className="btn assatz-btn">
          {isLoggedIn ? "Go to Dashboard" : mainTitle}
        </Link>
      </div>
    </Container>
  );
};

export default HeroSection;
