import React from "react";
import { Col } from "reactstrap";

const FooterMap = ({ isActive, setIsActive }) => {
  return (
    <Col xl="3" md="6" sm="12" className="mb-4">
      <div className="footer-links">
        <h5
          className="footer-title"
          onClick={(e) => {
            e.preventDefault();
            setIsActive("OurLocation");
            isActive === "OurLocation" && setIsActive();
          }}
        >
          Our Location
          <span className="according-menu">
            <i className="fas fa-chevron-down"></i>
          </span>
        </h5>
        <div
          className={`footer-content ${
            isActive === "OurLocation" ? "d-block" : "d-none d-md-block"
          }`}
        >
          <div className="footer-map">
            <iframe
              title="realestate location"
              src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3803.0607026905867!2d78.41907331483204!3d17.413087285461207!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x3bcb9358f0a16b49%3A0x9d0d07baf407cc72!2sH.+No+%3A+8-2-120%2F77%2F4B%2C+2nd+Floor%2C+NVR+Towers%2C+Besides+TDP+Office%2C+Road+No+-+2%2C+Banjara+Hills%2C+Hyderabad+-+500034%2C+Telangana%2C+India!5e0!3m2!1sen!2sin!4v1637591011942!5m2!1sen!2sin"
              width="100%"
              height="300"
              frameBorder="0"
              style={{ border: 0 }}
              allowFullScreen=""
              aria-hidden="false"
              tabIndex="0"
            ></iframe>
          </div>
        </div>
      </div>
    </Col>
  );
};

export default FooterMap;
