import { createSlice } from '@reduxjs/toolkit';

const initialState = {
  mobileNumber: '',
  otp: '',
  isOtpSent: false,
  message: { text: '', type: '' },
  role: '',  // Added role to the initial state
};

const loginSlice = createSlice({
  name: 'login',
  initialState,
  reducers: {
    setMobileNumber: (state, action) => {
      state.mobileNumber = action.payload;
    },
    setOtp: (state, action) => {
      state.otp = action.payload;
    },
    setIsOtpSent: (state, action) => {
      state.isOtpSent = action.payload;
    },
    setMessage: (state, action) => {
      state.message = action.payload;
    },
    setRole: (state, action) => {
      state.role = action.payload;  // Set the role in the state
    },
  },
});

export const { setMobileNumber, setOtp, setIsOtpSent, setMessage, setRole } = loginSlice.actions;
export default loginSlice.reducer;
